﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.Business;

public partial class controls_RehabilitationProviderSelector : System.Web.UI.UserControl
{

    #region Public Member Variables

    public string SurveyTypeCode { get; set; }
    public string QuestionNumber { get; set; }
    public string QuestionText { get; set; }
    public string SelectedChoiceId { get; set; }

    public short StartTabIndex
    {
        set
        {
            LabelForQRP.TabIndex = value;
            rblRehabilitationProviderSelector.TabIndex = (short)(value + 1);
            RequiredFieldValidatorRPList.TabIndex = (short)(value + 2);
        }
        get
        {
            return LabelForQRP.TabIndex;
        }
    }

    #endregion

    #region Public Methods

    /// <summary>
    /// returns the selected value of the choice - choice id ... cast to int before save.
    /// </summary>
    /// <returns></returns>
    public string GetSelectedId()
    {
        return rblRehabilitationProviderSelector.SelectedValue;
    }

    /// <summary>
    /// returns the value to be stored in the survey_result - result_text field.
    /// </summary>
    /// <returns></returns>
    public string GetSelectedResultText()
    {
        if (rblRehabilitationProviderSelector.SelectedItem == null)
        {
            return "";
        }
        return rblRehabilitationProviderSelector.SelectedItem.Text;
    }

    /// <summary>
    /// Set other desc text.
    /// </summary>
    /// <param name="value"></param>
    
    #endregion

    /// <summary>
    /// Path_Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        LabelForQRP.Text = QuestionText;
        HiddenQRP.Value = QuestionNumber;
        HiddenSurveyTypeRP.Value = SurveyTypeCode;
    }

    /// <summary>
    /// Databound
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void rblRehabilitationProviderSelector_DataBound(object sender, EventArgs e)
    {
        if (!String.IsNullOrEmpty(SelectedChoiceId))
        {
            rblRehabilitationProviderSelector.SelectedValue = SelectedChoiceId;
        }
    }

    #region Caching

    private string IDFieldName { get { return this.ID + "_ID"; } }
    private string OtherFieldName { get { return this.ID + "_Other"; } }

    public void ReadFromCache(Dictionary<string, string> cache)
    {
        string value;
        if (cache.TryGetValue(IDFieldName, out value) && value != null)
        {
            this.SelectedChoiceId = value;
        }
    }

    public void WriteToCache(Dictionary<string, string> cache)
    {
        cache[IDFieldName] = GetSelectedId();
    }

    #endregion Caching
}